<?php

/**
 * This is the model class for table "Dziedzina".
 *
 * The followings are the available columns in table 'Dziedzina':
 * @property double $id
 * @property string $nazwa
 */
class Dziedzina extends CActiveRecord
{
	const MARKETING = 5;
	const MANAGEMENT = 6;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Dziedzina the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Dziedzina';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('nazwa', 'length', 'max'=>128),

			array('id, nazwa', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'dziedzinaFirmies'=>array(self::HAS_MANY, 'DziedzinaFirmy', 'idDziedziny'),
			'dziedzinaPracownikas'=>array(self::HAS_MANY, 'DziedzinaPracownika', 'idDziedziny'),
			'dziedzinaUzytkownikas'=>array(self::HAS_MANY, 'DziedzinaUzytkownika', 'idDziedziny'),
			'szkolenies'=>array(self::HAS_MANY, 'Szkolenie', 'idDziedzina'),
			'zlecenies'=>array(self::HAS_MANY, 'Zlecenie', 'idDziedziny'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Dziedzina', 'id'),
			'nazwa'=>Yii::t('Dziedzina', 'nazwa'),
		);
	}

	public static function nameToUrl($name, $small = false, $gray = false)
	{
		return Yii::app()->baseUrl . '/images/gui/' . strtolower($name)
			. ($small || $gray ? '_small' : '') . ($gray ? '_grey' : '') . '.png';
	}

	public function getNamesAsImageUrl($small = false, $gray = false)
	{
		return self::nameToUrl($this->nazwa, $small, $gray);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('nazwa', $this->nazwa, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	static private $_dziedziny;

	public static function listAll()
	{
		if (empty(self::$_dziedziny))
			self::$_dziedziny = CHtml::listData(self::model()->findAll('"id" >= 1 AND "id" <= 4'), 'id', 'nazwa');
		return self::$_dziedziny;
	}
}
